/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.PortManager;
import DE.siemens.ad.logo.comm.SerialPortDataTransfer;
import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.app.ModemManager;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PortSelectionPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    protected JButton fAutoDetectButton;
    protected JList fPortList;
    protected OptionsIfc fOptions;
    protected boolean fAutodetect = true;
    private transient String fAutoDetectButtonText;

    public PortSelectionPanel() {
        this.initComponents();
    }

    private boolean evaluateComPort() {
        boolean logoFound = false;
        DataTransfer dt = null;
        Enumeration k = CommPortIdentifier.getPortIdentifiers();
        while (k.hasMoreElements() && !logoFound) {
            CommPortIdentifier pIdent = (CommPortIdentifier)k.nextElement();
            try {
                if (pIdent.getPortType() != 1) continue;
                String portName = pIdent.getName();
                this.fAutoDetectButton.setText(portName);
                dt = SerialPortDataTransfer.openConnection(pIdent.getName(), false, false);
                logoFound = true;
                dt.closePort();
                this.fPortList.setSelectedValue(portName, true);
                this.fAutoDetectButton.setEnabled(false);
                break;
            }
            catch (Exception e) {
                if (dt == null) continue;
                dt.closePort();
                dt = null;
            }
        }
        if (!logoFound && this.isShowing()) {
            new LogoError(this.getParent(), "error.com.selectPort", "Evaluation COM-port failed\nPlease check \nMode of LOGO! is PC<-->LOGO!\nThe LOGO! PC-cable connects LOGO! to PC").display();
        }
        this.fAutoDetectButton.setText(this.fAutoDetectButtonText);
        this.fAutoDetectButton.setEnabled(true);
        return logoFound;
    }

    public String getTitle() {
        return Language.getString("dialog.options.connectionTab.label", "Port");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fPortList = new JList();
        this.add(new JScrollPane(this.fPortList));
        this.fPortList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PortSelectionPanel.this.fAutoDetectButton.setEnabled(true);
            }
        });
        this.fAutoDetectButton = new JButton("Auto detect");
        if (!System.getProperty("os.name").equals("Mac OS X") && !ModemManager.fConnectionModem) {
            this.add((Component)this.fAutoDetectButton, "South");
            this.fAutoDetectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PortSelectionPanel.this.fAutoDetectButton.setEnabled(false);
                    new Thread(){

                        public void run() {
                            PortSelectionPanel.this.evaluateComPort();
                        }
                    }.start();
                }
            });
        }
    }

    public void loadFieldContents() {
        this.fPortList.setListData(PortManager.getAvailableComPorts());
        this.fPortList.setSelectedValue(PortManager.getActualComPort(), true);
    }

    public void setComPortAutoDetected(boolean ad) {
        this.fAutodetect = ad;
    }

    public void setLabels() {
        this.fAutoDetectButtonText = Language.getString("dialog.options.connectionTab.autodetect", "auto detect");
        this.fAutoDetectButton.setText(this.fAutoDetectButtonText);
    }

    public void storeFieldContents() {
        Object selectedComPort = this.fPortList.getSelectedValue();
        if (selectedComPort != null) {
            PortManager.setPortSelection((String)selectedComPort);
        }
    }
}

